;Copyright 1997, 1999 by Henter-Joyce, Inc.
;Converted to JScript 1997 by CW
; Modified 3/3/99
; by DaveB
; Keeping in mind software speech users
; modified and updated 3/30/99 by DB
Include "hjconst.jsh" ; this is a line we paste in macros to
include "SndRec32.jsh"
include "SndRec32.jsm"


globals
	int SoundRecFirst,
	int nSuppressEcho,
	int LimitSpeech


Function AutoStartEvent() 
let nSuppressEcho = 1
if (SoundRecFirst == 0) then
	let SoundRecFirst = 1
Say (msg27, OT_HELP) ; "To select a button from the list, press"
	Say(GetScriptKeyName ("SelectAButton"), OT_HELP)
	Say (msg26, OT_HELP) ; "If you are using a software synthesizer, try toggling the LimitSpeech option with"
	Say (GetScriptKeyName ("LimitSpeech"), OT_HELP)
	if GetVerbosity() == 0 then 
	Say (msg1, OT_HELP) ;"Press Insert + the letter H for Jaws Hot Keys with Sound Recorder"
	EndIf ;End of Verbosity check
EndIf;End of SoundRecFirst check
EndFunction

Void Function AutoFinishEvent ()
let nSuppressEcho = 0
EndFunction

Void Function PressButton (int iButton, string sButton)
var
	handle hwnd
let hwnd = GetRealWindow (GetFocus ())
If (DialogActive ()) ||
(MenusActive ()) then
	Return
EndIf
SaveCursor ()
JAWSCursor ()
SaveCursor ()
MoveToControl (hwnd, iButton)
Delay (4)
if (GetControlID (GetCurrentWindow ()) != iButton) then
	Say (sButton + msg23 + msg17, OT_MESSAGE) ; "button not found"
	Return
EndIf
if LimitSpeech == 0 then
	Say (sButton, OT_MESSAGE)
EndIf
LeftMouseButton ()
EndFunction

Script  ScriptFileName()  
ScriptAndAppNames ("Sound Recorder")
EndScript

Script HotKeyHelp()  
;wn5="Sound Recorder"
if (StringContains (GetWindowName (GetRealWindow (GetFocus())), wn5)) ||
(! MenusActive ()) ||
(GetWindowClass (GetParent (GetFocus ())) != wcDialog) ||
(! DialogActive ()) then
	Say (msg27, OT_HELP) ; "To select a button from the list, press"
	Say (GetScriptKeyName ("SelectAButton"), OT_HELP)
	Say (msg26, OT_HELP) ; "If you are using a software synthesizer, try toggling the LimitSpeech option with"
	Say (GetScriptKeyName ("LimitSpeech"), OT_HELP)
	Say (msg6, OT_HELP) ; you ;"Use Control with the following keys to run sound recorder"
;can get creative here.
	Say (msg7, OT_HELP); "R for record button"
	Say (msg8, OT_HELP) ;"P for play button"
	Say (msg9, OT_HELP) ;"S for stop button"
	Say (msg10, OT_HELP); "B for rewind button"
	Say (msg11, OT_HELP) ;"F for Fast Forward button"
else ; Default HotKeyHelp
	PerformScript HotKeyHelp()
EndIf
EndScript

Script StartRecord()
PressButton (record, msg19) ; "record"
EndScript

Script ClickStop()  
PressButton (stop, msg22) ; "stop"
EndScript

Script ClickPlay()
PressButton (play, msg18) ; "play"
EndScript

Script ClickFastForward()
PressButton (forward, msg21) ; "forward"
EndScript

Script ClickRewind()
PressButton (rewind, msg20) ; "rewind"
EndScript

Script LimitSpeech ()
if (LimitSpeech == 0) then
	let LimitSpeech = 1;
	Say (msg24, OT_MESSAGE) ; "LimitSpeech on"
	Return
EndIf
if (LimitSpeech >= 1) then
	let LimitSpeech = 0;
	Say (msg25, OT_MESSAGE) ; LimitSpeech off"
	Return;
EndIf
EndScript

Script SelectAButton ()
var
	int index
let index = 0;
if (DialogActive ()) ||
(MenusActive ()) then
	Say (msg23 + msg17, OT_MESSAGE) ; "Button not found"
	Return
EndIf ; if not in SoundRecorder main window
let nSuppressEcho = true
let index = DlgSelectItemInList (strToolbar, strDialogName, true)
Delay (2)
if (index == 1) then
	PressButton (forward, msg21) ; "forward"
ElIf (index == 2) then 
	PressButton (play, msg18) ; "play"
ElIf (index == 3) then
	PressButton (record, msg19) ; "Record"
ElIf (index == 4) then
	PressButton (rewind, msg20) ; "Rewind"
ElIf (index == 5) then
	PressButton (stop, msg22) ; "stop"
EndIf
EndScript
